Attribute VB_Name = "modStatstringParsing"
'-----------------------------------------------------
' MirageBot Statstring Parsing Module
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Public Type UserInfo
    Username As String
    Icon As Integer
    PingColor As Long
    color As Long
    Clan As String
    Index As Integer
    Ping As Long
    Flags As Long
    Statstring As String
    Account As String
End Type

Private Function GetRank(Index As Integer, Username As String) As Integer
    On Error GoTo hErr:
    GetRank = CInt(frmBot.Bot(Index).Clan.GetByName(Username).Rank)
    Exit Function
hErr:
    GetRank = -1
End Function

Public Function GetInformation(Index As Integer, Username As String, Statstring As String, Flags As Long, Ping As Long) As UserInfo
    Dim U As UserInfo, R As Integer
    U.Account = Suffix(Username)
    R = GetRank(Index, U.Account)
    U.Flags = Flags
    U.Ping = Ping
    U.Statstring = Statstring
    U.Username = Abbr(U.Account)
    U.Clan = GetClanName(Statstring)
    U.Index = frmBot.Bot(Index).Users.Find(U.Account)
    U.color = GetUserColor(Index, U.Account, Flags)
    U.PingColor = GetPingColor(Ping)
    U.Icon = ClientIconIndex(Index, Statstring, Flags, R)
    If LenB(U.Clan) = 0 Then U.Clan = " "
    If U.color = -1 Then U.color = vbWhite
    GetInformation = U
End Function
    
Public Function ClientIconIndex(Index As Integer, Statstring As String, Flags As Long, Optional Rank As Integer = -1) As Integer
    On Error GoTo hErr
    'If Len(Statstring) < 4 Then ClientIconIndex = 17: Exit Function
    Dim IconIndex As Integer
    Select Case StrReverse$(Left$(Statstring, 4))
        Case "WAR3": IconIndex = 6
        Case "W3XP": IconIndex = 7
        Case "DSHR": IconIndex = 8
        Case "DRTL": IconIndex = 9
        Case "D2DV": IconIndex = 10
        Case "D2XP": IconIndex = 11
        Case "SSHR": IconIndex = 12
        Case "JSTR": IconIndex = 13
        Case "STAR": IconIndex = 14
        Case "SEXP": IconIndex = 15
        Case "W2BN": IconIndex = 16
        Case "CHAT": IconIndex = 18
        Case Else:   IconIndex = 17
    End Select
    If (Flags And &H2) Then IconIndex = 5
    If (Flags And &H1) Then IconIndex = 1
    If (Flags And &H8) Then IconIndex = 2
    If (Flags And &H4) Then IconIndex = 3
    If (Flags And &H20) Then IconIndex = 4
    If Options.ClanRankIcons = False Then
        Select Case Rank
            Case 0, 1: IconIndex = 19
            Case 2: IconIndex = 20
            Case 3: IconIndex = 21
            Case 4: IconIndex = 22
        End Select
    End If
    ClientIconIndex = IconIndex
    Exit Function
hErr:
    ClientIconIndex = 17
    ErrorHandler Err.Description, Erl, "Iconset", "ClientIconIndex"
End Function

Public Function GetClientName(ByRef ProductID$) As String
On Error GoTo hErr
    Select Case UCase$(ProductID)
        Case "CHAT", "TAHC": GetClientName = "Telnet Client"
        Case "STAR", "RATS": GetClientName = "StarCraft"
        Case "JSTR", "RTSJ": GetClientName = "StarCraft Japanese"
        Case "SSHR", "RHSS": GetClientName = "StarCraft Shareware"
        Case "SEXP", "PXES": GetClientName = "StarCraft BroodWar"
        Case "W2BN", "NB2W": GetClientName = "WarCraft II Battle.net Edition"
        Case "WAR3", "3RAW": GetClientName = "WarCraft III Reign of Chaos"
        Case "W3XP", "PX3W": GetClientName = "WarCraft III Frozen Throne"
        Case "D2DV", "VD2D": GetClientName = "Diablo II Classic"
        Case "D2XP", "PX2D": GetClientName = "Diablo II Lord of Destruction"
        Case "DRTL", "LTRD": GetClientName = "Diablo"
        Case "DSHR", "RHSD": GetClientName = "Diablo Shareware"
        Case Else: GetClientName = "Unknown (" & ProductID & ")"
    End Select
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "Statstring", "GetClientName"
End Function

Public Function GetClanName(ByVal Statstring$) As String
On Error GoTo hErr
    If LenB(Statstring) = 0 Then Exit Function
    If Left$(Statstring, 4) = "3RAW" Or Left$(Statstring, 4) = "PX3W" Then
        If InStrB(Statstring, " ") <> 0 Then
            Dim Splt() As String
            Splt() = Split(Statstring, Space$(1))
            If UBound(Splt) >= 3 Then
                GetClanName = Replace$(StrReverse$(Splt(3)), vbNullChar, vbNullString)
            End If
        End If
    End If
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "Statstring", "GetClanName"
End Function

Public Function GetClientStats(ByVal Statstring$) As String
On Error GoTo hErr
    If Len(Statstring) < 5 Then Exit Function
    Select Case UCase$(Left$(Statstring, 4))
        Case "STAR", "RATS", "JSTR", "RTSJ", "SEXP", "PXES", "SSHR", "RHSS", "W2BN", "NB2W"
            GetClientStats = GetStarCraftStats(Statstring$)
        Case "DRTL", "LTRD", "DSHR", "RHSD"
            GetClientStats = GetDiabloStats(Statstring$)
        Case "WAR3", "3RAW"
            GetClientStats = GetReignOfChaosStats(Statstring$)
        Case "W3XP", "PX3W"
            GetClientStats = GetFrozenThroneStats(Statstring$)
        Case "D2DV", "VD2D", "D2XP", "PX2D"
            GetClientStats = GetDiablo2Stats(Statstring$)
        Case Else
            GetClientStats = vbNullString
    End Select
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "Statstring", "GetClientStats"
End Function

Private Function GetStarCraftStats(ByRef Statstring$) As String
On Error GoTo hErr
1   If InStr(Statstring, Space$(1)) > 0 Then
        Dim w$()
2       w$() = Split(Statstring, Space$(1))
3       If UBound(w) >= 4 Then
4           GetStarCraftStats = w$(3) & " wins" & IIf(Val(w$(2)) > 0, ", #" & w$(2), vbNullString) & IIf(Val(w$(1)) > 0, ", " & w$(1) & " rating", vbNullString) & IIf(Val(w$(4)) = 1, ", spawned", vbNullString)
        End If
    End If
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "Statstring", "GetStarCraftStats (" & Statstring & ")"
End Function

Public Function GetWins(ByRef Statstring$) As Double
On Error GoTo hErr
    If InStrB(Statstring, " ") <> 0 Then
        Dim w$()
        w$() = Split(Statstring, Space$(1))
        GetWins = Val(w$(3))
    End If
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "Statstring", "GetWins"
End Function

Private Function GetReignOfChaosStats(ByRef Statstring) As String
On Error GoTo hErr
    Dim S As String
1   S = CStr(Statstring)
    'No tier
2   If Len(S) = 4 Then Exit Function
    
    If InStrB(Statstring, " ") <> 0 Then
        'Get tier
        Dim Tier As String
4       Tier = Left$(Split(S, " ")(1), 2)
        
        'Check if peon
5       If Val(Left$(Tier, 1)) = 1 Then GetReignOfChaosStats = "Orc Peon": Exit Function
        
        'Create tier arrays
        Dim buf As String
6       Dim hTier(), eTier(), oTier(), uTier(), rTier()
        
        'Build arrays
7       hTier() = Array("Footman (25+ wins)", "Knight (250+ wins)", "Archmage (500+ wins)", "Medivh (1500+ wins)")
8       oTier() = Array("Grunt (25+ wins)", "Tauren (250+ wins)", "Far Seer (500+ wins)", "Thrall (1500+ wins)")
9       eTier() = Array("Archer (25+ wins)", "Druid of the Claw (250+ wins)", "Priestess of the Moon (500+ wins)", "Furion Stormrage (1500+ wins)")
10      uTier() = Array("Ghoul (25+ wins)", "Abomination (250+ wins)", "Lich (500+ wins)", "Tichondrius (1500+ wins)")
11      rTier() = Array("Green Dragon Whelp (25+ wins)", "Blue Dragon (250+ wins)", "Red Dragon (500+ wins)", "Deathwing (1500+ wins)")
        
        Dim lvl As Long
        lvl = Val(Left$(Tier, 1)) - 2
        Debug.Print "RoC Level: " & lvl
        Debug.Print Tier
        If lvl < 0 Or lvl > 4 Then Exit Function
        
        'Build buffer
        Select Case Mid$(Tier, 2, 1)
            Case "H": buf = "Human " & CStr(hTier(lvl))
13          Case "N": buf = "Night Elf " & CStr(eTier(lvl))
14          Case "O": buf = "Orc " & CStr(oTier(lvl))
15          Case "R": buf = "Random " & CStr(rTier(lvl))
16          Case "U": buf = "Undead " & CStr(uTier(lvl))
        End Select
        
        Erase hTier, oTier, eTier, uTier, rTier
        
        ''Return
17      GetReignOfChaosStats = buf
    End If
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "Statstring", "GetReignOfChaosStats (" & Statstring & ")"
End Function

Public Function GetTier(ByRef Statstring$) As String
    If Len(Statstring) = 4 Then
        GetTier = vbNullString
        Exit Function
    End If
    If InStrB(Statstring, " ") <> 0 Then
        GetTier = Left$(Split(Statstring, Space$(1))(1), 2)
    End If
End Function

Private Function GetFrozenThroneStats(ByRef Statstring) As String
On Error GoTo hErr
    Dim S As String
1   S = CStr(Statstring)
    ''No tier
2   If Len(S) = 4 Then Exit Function
    
    If InStrB(Statstring, " ") <> 0 Then
        ''Get tier
        Dim Tier As String
4       Tier = Left$(Split(S, " ")(1), 2)
        
        ''Check if peon
5       If Val(Left$(Tier, 1)) = 1 Then GetFrozenThroneStats = "Orc Peon": Exit Function

        Dim buf As String, hTier(), eTier(), oTier(), uTier(), tTier(), rTier()
        
        ''Build arrays
7       hTier() = Array("Rifleman (25+ wins)", "Sorceress (150+ wins)", "Spellbreaker (350+ wins)", "Blood Mage (750+ wins)", "Jaina (1500+ wins)")
8       oTier() = Array("Troll Headhunter (25+ wins)", "Shaman (150+ wins)", "Spirit Walker (350+ wins)", "Shadow Hunter (750+ wins)", "Rexxar (1500+ wins)")
9       eTier() = Array("Huntress (25+ wins)", "Druid of the Talon (150+ wins)", "Dryad (350+ wins)", "Keeper of the Grove (750+ wins)", "Maiev (1500+ wins)")
10      uTier() = Array("Crypt Fiend (25+ wins)", "Banshee (150+ wins)", "Destroyer (350+ wins)", "Crypt Lord (750+ wins)", "Sylvanas (1500+ wins)")
11      rTier() = Array("Myrmidon (25+ wins)", "Siren (150+ wins)", "Dragon Turtle (350+ wins)", "Sea Witch (750+ wins)", "Illidan (1500+ wins)")
12      tTier() = Array("Felguard (25+ wins)", "Infernal (150+ wins)", "Doomguard (350+ wins)", "Pit Lord (750+ wins)", "Archimonde (1500+ wins)")
        
        'PX3W 6O3W 22 FFA
        
        Dim lvl As Long
        lvl = Val(Left$(Tier, 1)) - 2
        If lvl < 0 Or lvl > 5 Then Exit Function
        
        ''Build buffer
        Select Case Mid$(Tier, 2, 1)
            Case "H": buf = "Human " & CStr(hTier(lvl))
14          Case "N": buf = "Night Elf " & CStr(eTier(lvl))
15          Case "O": buf = "Orc " & CStr(oTier(lvl))
16          Case "R": buf = "Random " & CStr(rTier(lvl))
17          Case "T": buf = "Tournament " & CStr(tTier(lvl))
18          Case "U": buf = "Undead " & CStr(uTier(lvl))
        End Select
        
        Erase hTier, oTier, eTier, uTier, rTier, tTier
        
        ''Return
19      GetFrozenThroneStats = buf
    End If
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "Statstring", "GetFrozenThroneStats (" & Statstring & ")"
End Function

Private Function GetDiabloStats(ByRef Statstring$) As String
On Error GoTo hErr
    If InStrB(Statstring, " ") <> 0 Then
        Dim w$(), Class$
        w$() = Split(Statstring, Space$(1))
        
        If UBound(w$()) = 9 Then
            Dim C()
            C() = Array("Warrior", "Rogue", "Sorceror")
            
            If Val(w(2)) > 2 Or Val(w(2)) < 0 Then
                GetDiabloStats = "Invalid class: " & Statstring
                Exit Function
            Else
                Class = CStr(C(Val(w(2))))
            End If
        Else
            GetDiabloStats = "Invalid stats: " & Statstring
            Exit Function
        End If
        
        Dim I As Integer
        For I = 1 To UBound(w)
            If Not IsNumeric(w(I)) = False Then
                GetDiabloStats = "Invalid stats: " & Statstring
                Exit Function
            End If
        Next I
    
        GetDiabloStats = "lvl " & w$(1) & Space$(1) & Class & ", " & _
            w$(3) & " dots, " & w$(4) & " strength, " & _
            w$(5) & " magic, " & w$(6) & " dexterity, " & _
            w$(7) & " vitality, & " & w$(8) & " gold"
    End If
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "Statstring", "GetDiabloStats (" & Statstring & ")"
End Function

Public Sub GetDiablo2Detail(ByRef Statstring As String, ByRef Level As Byte, ByRef Class As String, ByRef Expansion As Boolean)
    If Len(Statstring) <> 33 Then Exit Sub
    
    Dim R()
    R() = Array("Unknown", "Amazon", "Sorceress", _
        "Necromancer", "Paladin", "Barbarian", "Druid", "Assassin")
    
    Dim Race As Byte, Char As Byte
    Race = CByte(Asc(Mid$(Statstring, 14, 1)))
    Level = CByte(Asc(Mid$(Statstring, 26, 1)))
    Char = CByte(Asc(Mid$(Statstring, 27, 1)))
    If (Char And &H20) Then Expansion = True
    If (Race > 7) Or (Race < 1) Then Race = 0
    Class = R(Race)
End Sub

Public Sub GetClassLevel(ByRef Statstring As String, ByRef outClass As String, ByRef outLevel As Byte)
On Error GoTo hErr
    If Len(Statstring) = 4 Then Exit Sub

    Dim R(), Race As Byte, Level As Byte, Server$, Char$
    R() = Array("Unknown", "Amazon", "Sorceress", "Necromancer", "Paladin", "Barbarian", "Druid", "Assassin")
    Statstring = Mid$(Statstring, 5)
    Server$ = Left$(Statstring, InStr(Statstring, ",") - 1)
    Statstring = Mid$(Statstring, Len(Server) + 2)
    Char$ = Left$(Statstring, InStr(Statstring, ",") - 1)
    Statstring = Mid$(Statstring, Len(Char) + 2)

    If Len(Statstring) <> 33 Then Exit Sub

    Race = CByte(Asc(Mid$(Statstring, 14, 1)))
    Level = CByte(Asc(Mid$(Statstring, 26, 1)))
    outClass = R(Race)
    outLevel = Level
    Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "Statstring", "GetClassLevel"
End Sub

Private Function GetDiablo2Stats(ByRef Statstring As String, Optional ByVal NoChar As Boolean = False) As String
On Error GoTo hErr
1   If Len(Statstring) = 4 Then
2       GetDiablo2Stats = vbNullString
        Exit Function
    End If
    
    Dim R()
3   R() = Array("Unknown", "Amazon", "Sorceress", "Necromancer", "Paladin", "Barbarian", "Druid", "Assassin")
    
    Dim Race As Byte, Level As Byte, charflag As Byte, actflag As Byte
    Dim hardcore As Boolean, ladder As Boolean, dead As Boolean
    Dim female As Boolean, Expansion As Boolean
    Dim product$, Server$, Char$, raceStr$, Title$
4   If Not NoChar Then
5       product$ = Left$(Statstring, 4)
6       Statstring = Mid$(Statstring, 5)
        If InStr(Statstring, ",") <> 0 Then
7           Server$ = Left$(Statstring, InStr(Statstring, ",") - 1)
8           Statstring = Mid$(Statstring, Len(Server) + 2)
            If InStr(Statstring, ",") <> 0 Then
9               Char$ = Left$(Statstring, InStr(Statstring, ",") - 1)
10              Statstring = Mid$(Statstring, Len(Char) + 2)
            End If
        End If
    End If
    
11  If Len(Statstring) <> 33 Then
        GetDiablo2Stats = vbNullString
        Exit Function
    End If
    
12  Race = CByte(Asc(Mid$(Statstring, 14, 1)))
13  Level = CByte(Asc(Mid$(Statstring, 26, 1)))
14  charflag = CByte(Asc(Mid$(Statstring, 27, 1)))
15  actflag = CByte(Asc(Mid$(Statstring, 28, 1)))
16  hardcore = CBool((charflag And &H4) = &H4)
17  ladder = CBool(Asc(Mid$(Statstring, 31, 1)) < &HFF)
    
18  If hardcore Then dead = CBool((charflag And &H8) = &H8)
    
19  If Race > 7 Or Race < 1 Then Race = 0
20  If Race = 1 Or Race = 2 Or Race = 7 Then female = True
21  raceStr = R(Race)
    
    Erase R
    
    If product = "PX2D" Then
22      If charflag And &H20 Then
23          Expansion = True
            Select Case RShift(actflag And &H18, 3)
                Case 1: Title = IIf(hardcore, "Destroyer", "Slayer ")
24              Case 2: Title = IIf(hardcore, "Conqueror", "Champion ")
25              Case 3: Title = IIf(hardcore, "Guardian ", IIf(female, "M", "P") & "atriarch ")
            End Select
        End If
    Else
        Select Case RShift(actflag And &H18, 3)
            Case 1: Title = IIf(hardcore, IIf(female, "Dame ", "Sir "), IIf(female, "Countess ", "Count "))
26          Case 2: Title = IIf(hardcore, IIf(female, "Lady ", "Lord "), IIf(female, "Duchess ", "Duke "))
27          Case 3: Title = IIf(hardcore, IIf(female, "Baroness ", "Baron "), IIf(female, "Queen ", "King "))
        End Select
    End If
    
28  GetDiablo2Stats = IIf(NoChar, vbNullString, Title & Char & ", ") & IIf(dead, "dead ", vbNullString) & _
        IIf(hardcore, "hardcore ", vbNullString) & IIf(ladder, "ladder ", vbNullString) & _
        IIf(Expansion, "exp ", vbNullString) & _
        raceStr & " (lvl " & Level & ")" ' & " on realm " & server
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "Statstring", "GetDiablo2Stats (" & Statstring & ")"
End Function

Private Function LShift(ByVal pnValue As Long, ByVal pnShift As Long) As Double:
    LShift = CDbl(pnValue * (2 ^ pnShift))
End Function

Private Function RShift(ByVal pnValue As Long, ByVal pnShift As Long) As Double
    RShift = CDbl(pnValue \ (2 ^ pnShift))
End Function
